"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about the IAM user or role whose credentials are used to call the operation.  No permissions are required to perform this operation. If an administrator adds a policy to your IAM user or role that explicitly denies access to the sts:GetCallerIdentity action, you can still perform this operation. Permissions are not required because the same information is returned when an IAM user or role is denied access. To view an example response, see I Am Not Authorized to Perform: iam:DeleteVirtualMFADevice in the IAM User Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sts.caller_identity.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sts.caller_identity.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sts", operation="get_caller_identity", op_kwargs={}
    )
