"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def notify(hub, ctx, file_share_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to Amazon S3. Storage Gateway can send a notification through Amazon CloudWatch Events when all files written to your file share up to that point in time have been uploaded to Amazon S3. These files include files written to the file share up to the time that you make a request for notification. When the upload is done, Storage Gateway sends you notification through an Amazon CloudWatch Event. You can configure CloudWatch Events to send the notification through event targets such as Amazon SNS or Lambda function. This operation is only supported for S3 File Gateways. For more information, see Getting file upload notification in the Storage Gateway User Guide.

    Args:
        file_share_arn(str): The Amazon Resource Name (ARN) of the file share.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.when_uploaded.notify(ctx, file_share_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.when_uploaded.notify file_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="notify_when_uploaded",
        op_kwargs={"FileShareARN": file_share_arn},
    )
