"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def update(hub, ctx, vtl_device_arn: str, device_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.

    Args:
        vtl_device_arn(str): The Amazon Resource Name (ARN) of the medium changer you want to select.
        device_type(str): The type of medium changer you want to select. Valid Values: STK-L700 | AWS-Gateway-VTL | IBM-03584L32-0402 .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.vtl_device.type_.update(
                ctx, vtl_device_arn=value, device_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.vtl_device.type.update vtl_device_arn=value, device_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_vtl_device_type",
        op_kwargs={"VTLDeviceARN": vtl_device_arn, "DeviceType": device_type},
    )
