"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    gateway_arn: str,
    vtl_device_ar_ns: List = None,
    marker: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information. This operation is only supported in the tape gateway type.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        vtl_device_ar_ns(List, optional): An array of strings, where each string represents the Amazon Resource Name (ARN) of a VTL device.  All of the specified VTL devices must be from the same gateway. If no VTL devices are specified, the result will contain all devices on the specified gateway. . Defaults to None.
        marker(str, optional): An opaque string that indicates the position at which to begin describing the VTL devices. Defaults to None.
        limit(int, optional): Specifies that the number of VTL devices described be limited to the specified number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.vtl_device.init.describe_all(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.vtl_device.init.describe_all gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_vtl_devices",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "VTLDeviceARNs": vtl_device_ar_ns,
            "Marker": marker,
            "Limit": limit,
        },
    )
