"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(
    hub,
    ctx,
    gateway_arn: str,
    volume_arn: str,
    network_interface_id: str,
    target_name: str = None,
    disk_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
        target_name(str, optional): The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying TargetName as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume. The target name must be unique across all volumes on a gateway. If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name. Defaults to None.
        volume_arn(str): The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
        network_interface_id(str): The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway. Valid Values: A valid IP address.
        disk_id(str, optional): The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This value is only required when you are attaching a stored volume. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.volume.init.attach(
                ctx, gateway_arn=value, volume_arn=value, network_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.volume.init.attach gateway_arn=value, volume_arn=value, network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="attach_volume",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "TargetName": target_name,
            "VolumeARN": volume_arn,
            "NetworkInterfaceId": network_interface_id,
            "DiskId": disk_id,
        },
    )


async def delete(hub, ctx, volume_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified storage volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume. Before you delete a volume, make sure there are no iSCSI connections to the volume you are deleting. You should also make sure there is no snapshot in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API to query snapshots on the volume you are deleting and check the snapshot status. For more information, go to DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference. In the request, you must provide the Amazon Resource Name (ARN) of the storage volume you want to delete.

    Args:
        volume_arn(str): The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation to return a list of gateway volumes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.volume.init.delete(ctx, volume_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.volume.init.delete volume_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_volume",
        op_kwargs={"VolumeARN": volume_arn},
    )


async def detach(hub, ctx, volume_arn: str, force_detach: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.

    Args:
        volume_arn(str): The Amazon Resource Name (ARN) of the volume to detach from the gateway.
        force_detach(bool, optional): Set to true to forcibly remove the iSCSI connection of the target volume and detach the volume. The default is false. If this value is set to false, you must manually disconnect the iSCSI connection from the target volume. Valid Values: true | false . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.volume.init.detach(ctx, volume_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.volume.init.detach volume_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="detach_volume",
        op_kwargs={"VolumeARN": volume_arn, "ForceDetach": force_detach},
    )


async def list_all(
    hub, ctx, gateway_arn: str = None, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes API. The operation supports pagination. By default, the operation returns a maximum of up to 100 volumes. You can optionally specify the Limit field in the body to limit the number of volumes in the response. If the number of volumes returned in the response is truncated, the response includes a Marker field. You can use this Marker value in your subsequent request to retrieve the next set of volumes. This operation is only supported in the cached volume and stored volume gateway types.

    Args:
        gateway_arn(str, optional): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region. Defaults to None.
        marker(str, optional): A string that indicates the position at which to begin the returned list of volumes. Obtain the marker from the response of a previous List iSCSI Volumes request. Defaults to None.
        limit(int, optional): Specifies that the list of volumes returned be limited to the specified number of items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.volume.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.volume.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_volumes",
        op_kwargs={"GatewayARN": gateway_arn, "Marker": marker, "Limit": limit},
    )
