"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    gateway_arn: str,
    tape_size_in_bytes: int,
    tape_barcode: str,
    kms_encrypted: bool = None,
    kms_key: str = None,
    pool_id: str = None,
    worm: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.  Cache storage must be allocated to the gateway before you can create a virtual tape. Use the AddCache operation to add cache storage to a gateway.

    Args:
        gateway_arn(str): The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the ListGateways operation to return a list of gateways for your account and Region.
        tape_size_in_bytes(int): The size, in bytes, of the virtual tape that you want to create.  The size must be aligned by gigabyte (1024*1024*1024 bytes). .
        tape_barcode(str): The barcode that you want to assign to the tape.  Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted. .
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        pool_id(str, optional): The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool. Valid Values: GLACIER | DEEP_ARCHIVE . Defaults to None.
        worm(bool, optional): Set to TRUE if the tape you are creating is to be configured as a write-once-read-many (WORM) tape. Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.with_barcode.create(
                ctx, gateway_arn=value, tape_size_in_bytes=value, tape_barcode=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.with_barcode.create gateway_arn=value, tape_size_in_bytes=value, tape_barcode=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_tape_with_barcode",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "TapeSizeInBytes": tape_size_in_bytes,
            "TapeBarcode": tape_barcode,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "PoolId": pool_id,
            "Worm": worm,
            "Tags": tags,
        },
    )
