"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, gateway_arn: str, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of virtual tape recovery points that are available for the specified tape gateway. A recovery point is a point-in-time view of a virtual tape at which all the data on the virtual tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway. This operation is only supported in the tape gateway type.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        marker(str, optional): An opaque string that indicates the position at which to begin describing the virtual tape recovery points. Defaults to None.
        limit(int, optional): Specifies that the number of virtual tape recovery points that are described be limited to the specified number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.recovery_point.describe_all(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.recovery_point.describe_all gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_tape_recovery_points",
        op_kwargs={"GatewayARN": gateway_arn, "Marker": marker, "Limit": limit},
    )


async def retrieve(hub, ctx, tape_arn: str, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type. A recovery point is a point in time view of a virtual tape at which all the data on the tape is consistent. If your gateway crashes, virtual tapes that have recovery points can be recovered to a new gateway.  The virtual tape can be retrieved to only one gateway. The retrieved tape is read-only. The virtual tape can be retrieved to only a tape gateway. There is no charge for retrieving recovery points.

    Args:
        tape_arn(str): The Amazon Resource Name (ARN) of the virtual tape for which you want to retrieve the recovery point.
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.recovery_point.retrieve(
                ctx, tape_arn=value, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.recovery_point.retrieve tape_arn=value, gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="retrieve_tape_recovery_point",
        op_kwargs={"TapeARN": tape_arn, "GatewayARN": gateway_arn},
    )
