"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def assign(
    hub, ctx, tape_arn: str, pool_id: str, bypass_governance_retention: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool. Valid Values: GLACIER | DEEP_ARCHIVE

    Args:
        tape_arn(str): The unique Amazon Resource Name (ARN) of the virtual tape that you want to add to the tape pool.
        pool_id(str): The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool. Valid Values: GLACIER | DEEP_ARCHIVE .
        bypass_governance_retention(bool, optional): Set permissions to bypass governance retention. If the lock type of the archived tape is Governance, the tape's archived age is not older than RetentionLockInDays, and the user does not already have BypassGovernanceRetention, setting this to TRUE enables the user to bypass the retention lock. This parameter is set to true by default for calls from the console. Valid values: TRUE | FALSE . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.pool.assign(
                ctx, tape_arn=value, pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.pool.assign tape_arn=value, pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="assign_tape_pool",
        op_kwargs={
            "TapeARN": tape_arn,
            "PoolId": pool_id,
            "BypassGovernanceRetention": bypass_governance_retention,
        },
    )


async def create(
    hub,
    ctx,
    pool_name: str,
    storage_class: str,
    retention_lock_type: str = None,
    retention_lock_time_in_days: int = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.

    Args:
        pool_name(str): The name of the new custom tape pool.
        storage_class(str): The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
        retention_lock_type(str, optional): Tape retention lock can be configured in two modes. When configured in governance mode, accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root account. Defaults to None.
        retention_lock_time_in_days(int, optional): Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days). Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to tape pool. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.pool.create(
                ctx, pool_name=value, storage_class=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.pool.create pool_name=value, storage_class=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_tape_pool",
        op_kwargs={
            "PoolName": pool_name,
            "StorageClass": storage_class,
            "RetentionLockType": retention_lock_type,
            "RetentionLockTimeInDays": retention_lock_time_in_days,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, pool_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.

    Args:
        pool_arn(str): The Amazon Resource Name (ARN) of the custom tape pool to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.pool.delete(ctx, pool_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.pool.delete pool_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_tape_pool",
        op_kwargs={"PoolARN": pool_arn},
    )


async def list_all(
    hub, ctx, pool_ar_ns: List = None, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools. This operation supports pagination. You can optionally specify the Limit parameter in the body to limit the number of tape pools in the response. If the number of tape pools returned in the response is truncated, the response includes a Marker element that you can use in your subsequent request to retrieve the next set of tape pools.

    Args:
        pool_ar_ns(List, optional): The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a custom tape pool ARN, the response lists all custom tape pools. . Defaults to None.
        marker(str, optional): A string that indicates the position at which to begin the returned list of tape pools. Defaults to None.
        limit(int, optional): An optional number limit for the tape pools in the list returned by this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.pool.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.pool.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_tape_pools",
        op_kwargs={"PoolARNs": pool_ar_ns, "Marker": marker, "Limit": limit},
    )
