"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    gateway_arn: str,
    tape_size_in_bytes: int,
    client_token: str,
    num_tapes_to_create: int,
    tape_barcode_prefix: str,
    kms_encrypted: bool = None,
    kms_key: str = None,
    pool_id: str = None,
    worm: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.  Cache storage must be allocated to the gateway before you can create virtual tapes. Use the AddCache operation to add cache storage to a gateway.

    Args:
        gateway_arn(str): The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tapes with. Use the ListGateways operation to return a list of gateways for your account and Region.
        tape_size_in_bytes(int): The size, in bytes, of the virtual tapes that you want to create.  The size must be aligned by gigabyte (1024*1024*1024 bytes). .
        client_token(str): A unique identifier that you use to retry a request. If you retry a request, use the same ClientToken you specified in the initial request.  Using the same ClientToken prevents creating the tape multiple times. .
        num_tapes_to_create(int): The number of virtual tapes that you want to create.
        tape_barcode_prefix(str): A prefix that you append to the barcode of the virtual tape you are creating. This prefix makes the barcode unique.  The prefix must be 1-4 characters in length and must be one of the uppercase letters from A to Z. .
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        pool_id(str, optional): The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool. Valid Values: GLACIER | DEEP_ARCHIVE . Defaults to None.
        worm(bool, optional): Set to TRUE if the tape you are creating is to be configured as a write-once-read-many (WORM) tape. Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to a virtual tape. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.init.create_multiple(
                ctx,
                gateway_arn=value,
                tape_size_in_bytes=value,
                client_token=value,
                num_tapes_to_create=value,
                tape_barcode_prefix=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.init.create_multiple gateway_arn=value, tape_size_in_bytes=value, client_token=value, num_tapes_to_create=value, tape_barcode_prefix=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_tapes",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "TapeSizeInBytes": tape_size_in_bytes,
            "ClientToken": client_token,
            "NumTapesToCreate": num_tapes_to_create,
            "TapeBarcodePrefix": tape_barcode_prefix,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "PoolId": pool_id,
            "Worm": worm,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, gateway_arn: str, tape_arn: str, bypass_governance_retention: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified virtual tape. This operation is only supported in the tape gateway type.

    Args:
        gateway_arn(str): The unique Amazon Resource Name (ARN) of the gateway that the virtual tape to delete is associated with. Use the ListGateways operation to return a list of gateways for your account and Region.
        tape_arn(str): The Amazon Resource Name (ARN) of the virtual tape to delete.
        bypass_governance_retention(bool, optional): Set to TRUE to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to governance can be deleted. Archived tapes with tape retention lock set to compliance can't be deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.init.delete(
                ctx, gateway_arn=value, tape_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.init.delete gateway_arn=value, tape_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_tape",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "TapeARN": tape_arn,
            "BypassGovernanceRetention": bypass_governance_retention,
        },
    )


async def describe_all(
    hub,
    ctx,
    gateway_arn: str,
    tape_ar_ns: List = None,
    marker: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes. If a TapeARN is not specified, returns a description of all virtual tapes associated with the specified gateway. This operation is only supported in the tape gateway type.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        tape_ar_ns(List, optional): Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. If this parameter is not specified, Tape gateway returns a description of all virtual tapes associated with the specified gateway. Defaults to None.
        marker(str, optional): A marker value, obtained in a previous call to DescribeTapes. This marker indicates which page of results to retrieve. If not specified, the first page of results is retrieved. Defaults to None.
        limit(int, optional): Specifies that the number of virtual tapes described be limited to the specified number.  Amazon Web Services may impose its own limit, if this field is not set. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.init.describe_all(ctx, gateway_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.init.describe_all gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_tapes",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "TapeARNs": tape_ar_ns,
            "Marker": marker,
            "Limit": limit,
        },
    )


async def list_all(
    hub, ctx, tape_ar_ns: List = None, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS. This operation supports pagination. By default, the operation returns a maximum of up to 100 tapes. You can optionally specify the Limit parameter in the body to limit the number of tapes in the response. If the number of tapes returned in the response is truncated, the response includes a Marker element that you can use in your subsequent request to retrieve the next set of tapes. This operation is only supported in the tape gateway type.

    Args:
        tape_ar_ns(List, optional): The Amazon Resource Name (ARN) of each of the tapes you want to list. If you don't specify a tape ARN, the response lists all tapes in both your VTL and VTS. Defaults to None.
        marker(str, optional): A string that indicates the position at which to begin the returned list of tapes. Defaults to None.
        limit(int, optional): An optional number limit for the tapes in the list returned by this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_tapes",
        op_kwargs={"TapeARNs": tape_ar_ns, "Marker": marker, "Limit": limit},
    )
