"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, tape_arn: str, bypass_governance_retention: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.

    Args:
        tape_arn(str): The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual tape shelf (VTS).
        bypass_governance_retention(bool, optional): Set to TRUE to delete an archived tape that belongs to a custom pool with tape retention lock. Only archived tapes with tape retention lock set to governance can be deleted. Archived tapes with tape retention lock set to compliance can't be deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.archive.delete(ctx, tape_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.archive.delete tape_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_tape_archive",
        op_kwargs={
            "TapeARN": tape_arn,
            "BypassGovernanceRetention": bypass_governance_retention,
        },
    )


async def describe_all(
    hub, ctx, tape_ar_ns: List = None, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type. If a specific TapeARN is not specified, Storage Gateway returns a description of all virtual tapes found in the VTS associated with your account.

    Args:
        tape_ar_ns(List, optional): Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe. Defaults to None.
        marker(str, optional): An opaque string that indicates the position at which to begin describing virtual tapes. Defaults to None.
        limit(int, optional): Specifies that the number of virtual tapes described be limited to the specified number. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.archive.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.archive.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_tape_archives",
        op_kwargs={"TapeARNs": tape_ar_ns, "Marker": marker, "Limit": limit},
    )


async def retrieve(hub, ctx, tape_arn: str, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type. Once a tape is successfully retrieved to a gateway, it cannot be retrieved again to another gateway. You must archive the tape again before you can retrieve it to another gateway. This operation is only supported in the tape gateway type.

    Args:
        tape_arn(str): The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from the virtual tape shelf (VTS).
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual tape to. Use the ListGateways operation to return a list of gateways for your account and Region. You retrieve archived virtual tapes to only one gateway and the gateway must be a tape gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tape.archive.retrieve(
                ctx, tape_arn=value, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tape.archive.retrieve tape_arn=value, gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="retrieve_tape_archive",
        op_kwargs={"TapeARN": tape_arn, "GatewayARN": gateway_arn},
    )
