"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource you want to remove the tags from.
        tag_keys(List): The keys of the tags you want to remove from the specified resource. A tag is composed of a key-value pair.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tags.from_resource.remove(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tags.from_resource.remove resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceARN": resource_arn, "TagKeys": tag_keys},
    )
