"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, marker: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource for which you want to list tags.
        marker(str, optional): An opaque string that indicates the position at which to begin returning the list of tags. Defaults to None.
        limit(int, optional): Specifies that the list of tags returned be limited to the specified number of items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.tags.for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.tags.for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceARN": resource_arn, "Marker": marker, "Limit": limit},
    )
