"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    gateway_arn: str,
    disk_id: str,
    preserve_existing_data: bool,
    target_name: str,
    network_interface_id: str,
    snapshot_id: str = None,
    kms_encrypted: bool = None,
    kms_key: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type. The size of the volume to create is inferred from the disk size. You can choose to preserve existing data on the disk, create volume from an existing snapshot, or create an empty volume. If you choose to create an empty gateway volume, then any existing data on the disk is erased. In the request, you must specify the gateway and the disk information on which you are creating the volume. In response, the gateway creates the volume and returns volume information such as the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        disk_id(str): The unique identifier for the gateway local disk that is configured as a stored volume. Use ListLocalDisks to list disk IDs for a gateway.
        snapshot_id(str, optional): The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as the new stored volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference. Defaults to None.
        preserve_existing_data(bool): Set to true if you want to preserve the data on the local disk. Otherwise, set to false to create an empty volume. Valid Values: true | false .
        target_name(str): The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying TargetName as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume. The target name must be unique across all volumes on a gateway. If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
        network_interface_id(str): The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway. Valid Values: A valid IP address.
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to a stored volume. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.stored_iscsi_volume.create(
                ctx,
                gateway_arn=value,
                disk_id=value,
                preserve_existing_data=value,
                target_name=value,
                network_interface_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.stored_iscsi_volume.create gateway_arn=value, disk_id=value, preserve_existing_data=value, target_name=value, network_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_stored_iscsi_volume",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "DiskId": disk_id,
            "SnapshotId": snapshot_id,
            "PreserveExistingData": preserve_existing_data,
            "TargetName": target_name,
            "NetworkInterfaceId": network_interface_id,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "Tags": tags,
        },
    )


async def describe_all(hub, ctx, volume_ar_ns: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.

    Args:
        volume_ar_ns(List): An array of strings where each string represents the Amazon Resource Name (ARN) of a stored volume. All of the specified stored volumes must be from the same gateway. Use ListVolumes to get volume ARNs for a gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.stored_iscsi_volume.describe_all(
                ctx, volume_ar_ns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.stored_iscsi_volume.describe_all volume_ar_ns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_stored_iscsi_volumes",
        op_kwargs={"VolumeARNs": volume_ar_ns},
    )
