"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, volume_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a snapshot of a volume. You can take snapshots of your gateway volumes on a scheduled or ad hoc basis. This API action enables you to delete a snapshot schedule for a volume. For more information, see Backing up your volumes. In the DeleteSnapshotSchedule request, you identify the volume by providing its Amazon Resource Name (ARN). This operation is only supported in stored and cached volume gateway types.  To list or delete a snapshot, you must use the Amazon EC2 API. For more information, go to DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference.

    Args:
        volume_arn(str): The volume which snapshot schedule to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.snapshot.schedule.delete(ctx, volume_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.snapshot.schedule.delete volume_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_snapshot_schedule",
        op_kwargs={"VolumeARN": volume_arn},
    )


async def describe(hub, ctx, volume_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.

    Args:
        volume_arn(str): The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation to return a list of gateway volumes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.snapshot.schedule.describe(ctx, volume_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.snapshot.schedule.describe volume_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_snapshot_schedule",
        op_kwargs={"VolumeARN": volume_arn},
    )


async def update(
    hub,
    ctx,
    volume_arn: str,
    start_at: int,
    recurrence_in_hours: int,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types. The default snapshot schedule for volume is once every 24 hours, starting at the creation time of the volume. You can use this API to change the snapshot schedule configured for the volume. In the request you must identify the gateway volume whose snapshot schedule you want to update, and the schedule information, including when you want the snapshot to begin on a day and the frequency (in hours) of snapshots.

    Args:
        volume_arn(str): The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation to return a list of gateway volumes.
        start_at(int): The hour of the day at which the snapshot schedule begins represented as hh, where hh is the hour (0 to 23). The hour of the day is in the time zone of the gateway.
        recurrence_in_hours(int): Frequency of snapshots. Specify the number of hours between snapshots.
        description(str, optional): Optional description of the snapshot that overwrites the existing description. Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.snapshot.schedule.update(
                ctx, volume_arn=value, start_at=value, recurrence_in_hours=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.snapshot.schedule.update volume_arn=value, start_at=value, recurrence_in_hours=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_snapshot_schedule",
        op_kwargs={
            "VolumeARN": volume_arn,
            "StartAt": start_at,
            "RecurrenceInHours": recurrence_in_hours,
            "Description": description,
            "Tags": tags,
        },
    )
