"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.setting.describe_all(ctx, gateway_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.setting.describe_all gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_smb_settings",
        op_kwargs={"GatewayARN": gateway_arn},
    )
