"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, gateway_arn: str, password: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the password for the guest user smbguest. The smbguest user is the user when the authentication method for the file share is set to GuestAccess. This operation only supported for S3 File Gateways

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share is associated with.
        password(str): The password that you want to set for your SMB server.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.guest_password.set(
                ctx, gateway_arn=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.guest_password.set gateway_arn=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="set_smb_guest_password",
        op_kwargs={"GatewayARN": gateway_arn, "Password": password},
    )
