"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, gateway_arn: str, file_shares_visible: bool) -> Dict:
    r"""
    **Autogenerated function**

    Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        file_shares_visible(bool): The shares on this gateway appear when listing shares.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.file_share.visibility.update(
                ctx, gateway_arn=value, file_shares_visible=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.file_share.visibility.update gateway_arn=value, file_shares_visible=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_smb_file_share_visibility",
        op_kwargs={"GatewayARN": gateway_arn, "FileSharesVisible": file_shares_visible},
    )
