"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    gateway_arn: str,
    role: str,
    location_arn: str,
    kms_encrypted: bool = None,
    kms_key: str = None,
    default_storage_class: str = None,
    object_acl: str = None,
    read_only: bool = None,
    guess_mime_type_enabled: bool = None,
    requester_pays: bool = None,
    smbacl_enabled: bool = None,
    access_based_enumeration: bool = None,
    admin_user_list: List = None,
    valid_user_list: List = None,
    invalid_user_list: List = None,
    audit_destination_arn: str = None,
    authentication: str = None,
    case_sensitivity: str = None,
    tags: List = None,
    file_share_name: str = None,
    cache_attributes: Dict = None,
    notification_policy: str = None,
    vpc_endpoint_dns_name: str = None,
    bucket_region: str = None,
    oplocks_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.  S3 File Gateways require Security Token Service (STS) to be activated to enable you to create a file share. Make sure that STS is activated in the Region you are creating your S3 File Gateway in. If STS is not activated in this Region, activate it. For information about how to activate STS, see Activating and deactivating STS in an Region in the Identity and Access Management User Guide. File gateways don't support creating hard or symbolic links on a file share.

    Args:
        client_token(str): A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.
        gateway_arn(str): The ARN of the S3 File Gateway on which you want to create a file share.
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        role(str): The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.
        location_arn(str): The ARN of the backend storage used for storing file data. A prefix name can be added to the S3 bucket name. It must end with a "/".  You can specify a bucket attached to an access point using a complete ARN that includes the bucket region as shown:  arn:aws:s3:region:account-id:accesspoint/access-point-name   If you specify a bucket attached to an access point, the bucket policy must be configured to delegate access control to the access point. For information, see Delegating access control to access points in the Amazon S3 User Guide. .
        default_storage_class(str, optional): The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is S3_INTELLIGENT_TIERING. Optional. Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA . Defaults to None.
        object_acl(str, optional): A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is private. Defaults to None.
        read_only(bool, optional): A value that sets the write status of a file share. Set this value to true to set the write status to read-only, otherwise set to false. Valid Values: true | false . Defaults to None.
        guess_mime_type_enabled(bool, optional): A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to true to enable MIME type guessing, otherwise set to false. The default value is true. Valid Values: true | false . Defaults to None.
        requester_pays(bool, optional): A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to true, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.  Valid Values: true | false . Defaults to None.
        smbacl_enabled(bool, optional): Set this value to true to enable access control list (ACL) on the SMB file share. Set it to false to map file and directory permissions to the POSIX permissions. For more information, see Using Microsoft Windows ACLs to control access to an SMB file share in the Storage Gateway User Guide. Valid Values: true | false . Defaults to None.
        access_based_enumeration(bool, optional): The files and folders on this share will only be visible to users with read access. Defaults to None.
        admin_user_list(List, optional): A list of users or groups in the Active Directory that will be granted administrator privileges on the file share. These users can do all file operations as the super-user. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1.  Use this option very carefully, because any user in this list can do anything they like on the file share, regardless of file permissions. . Defaults to None.
        valid_user_list(List, optional): A list of users or groups in the Active Directory that are allowed to access the file  share. A group must be prefixed with the @ character. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only be set if Authentication is set to ActiveDirectory. Defaults to None.
        invalid_user_list(List, optional): A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only be set if Authentication is set to ActiveDirectory. Defaults to None.
        audit_destination_arn(str, optional): The Amazon Resource Name (ARN) of the storage used for audit logs. Defaults to None.
        authentication(str, optional): The authentication method that users use to access the file share. The default is ActiveDirectory. Valid Values: ActiveDirectory | GuestAccess . Defaults to None.
        case_sensitivity(str, optional): The case of an object name in an Amazon S3 bucket. For ClientSpecified, the client determines the case sensitivity. For CaseSensitive, the gateway determines the case sensitivity. The default value is ClientSpecified. Defaults to None.
        tags(List, optional): A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256. . Defaults to None.
        file_share_name(str, optional): The name of the file share. Optional.   FileShareName must be set if an S3 prefix name is set in LocationARN. . Defaults to None.
        cache_attributes(Dict, optional): Specifies refresh cache information for the file share. Defaults to None.
        notification_policy(str, optional): The notification policy of the file share. SettlingTimeInSeconds controls the number of seconds to wait after the last point in time a client wrote to a file before generating an ObjectUploaded notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.   SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.  The following example sets NotificationPolicy on with SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The following example sets NotificationPolicy off.  {} . Defaults to None.
        vpc_endpoint_dns_name(str, optional): Specifies the DNS name for the VPC endpoint that the SMB file share uses to connect to Amazon S3.  This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point. . Defaults to None.
        bucket_region(str, optional): Specifies the Region of the S3 bucket where the SMB file share stores files.  This parameter is required for SMB file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point. . Defaults to None.
        oplocks_enabled(bool, optional): Specifies whether opportunistic locking is enabled for the SMB file share.  Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.  Valid Values: true | false . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.file_share.init.create(
                ctx, client_token=value, gateway_arn=value, role=value, location_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.file_share.init.create client_token=value, gateway_arn=value, role=value, location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_smb_file_share",
        op_kwargs={
            "ClientToken": client_token,
            "GatewayARN": gateway_arn,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "Role": role,
            "LocationARN": location_arn,
            "DefaultStorageClass": default_storage_class,
            "ObjectACL": object_acl,
            "ReadOnly": read_only,
            "GuessMIMETypeEnabled": guess_mime_type_enabled,
            "RequesterPays": requester_pays,
            "SMBACLEnabled": smbacl_enabled,
            "AccessBasedEnumeration": access_based_enumeration,
            "AdminUserList": admin_user_list,
            "ValidUserList": valid_user_list,
            "InvalidUserList": invalid_user_list,
            "AuditDestinationARN": audit_destination_arn,
            "Authentication": authentication,
            "CaseSensitivity": case_sensitivity,
            "Tags": tags,
            "FileShareName": file_share_name,
            "CacheAttributes": cache_attributes,
            "NotificationPolicy": notification_policy,
            "VPCEndpointDNSName": vpc_endpoint_dns_name,
            "BucketRegion": bucket_region,
            "OplocksEnabled": oplocks_enabled,
        },
    )


async def describe_all(hub, ctx, file_share_arn_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.

    Args:
        file_share_arn_list(List): An array containing the Amazon Resource Name (ARN) of each file share to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.file_share.init.describe_all(
                ctx, file_share_arn_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.file_share.init.describe_all file_share_arn_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_smb_file_shares",
        op_kwargs={"FileShareARNList": file_share_arn_list},
    )


async def update(
    hub,
    ctx,
    file_share_arn: str,
    kms_encrypted: bool = None,
    kms_key: str = None,
    default_storage_class: str = None,
    object_acl: str = None,
    read_only: bool = None,
    guess_mime_type_enabled: bool = None,
    requester_pays: bool = None,
    smbacl_enabled: bool = None,
    access_based_enumeration: bool = None,
    admin_user_list: List = None,
    valid_user_list: List = None,
    invalid_user_list: List = None,
    audit_destination_arn: str = None,
    case_sensitivity: str = None,
    file_share_name: str = None,
    cache_attributes: Dict = None,
    notification_policy: str = None,
    oplocks_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.  To leave a file share field unchanged, set the corresponding input field to null.   File gateways require Security Token Service (STS) to be activated to enable you to create a file share. Make sure that STS is activated in the Region you are creating your file gateway in. If STS is not activated in this Region, activate it. For information about how to activate STS, see Activating and deactivating STS in an Region in the Identity and Access Management User Guide. File gateways don't support creating hard or symbolic links on a file share.

    Args:
        file_share_arn(str): The Amazon Resource Name (ARN) of the SMB file share that you want to update.
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        default_storage_class(str, optional): The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is S3_INTELLIGENT_TIERING. Optional. Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING | S3_STANDARD_IA | S3_ONEZONE_IA . Defaults to None.
        object_acl(str, optional): A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is private. Defaults to None.
        read_only(bool, optional): A value that sets the write status of a file share. Set this value to true to set write status to read-only, otherwise set to false. Valid Values: true | false . Defaults to None.
        guess_mime_type_enabled(bool, optional): A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to true to enable MIME type guessing, otherwise set to false. The default value is true. Valid Values: true | false . Defaults to None.
        requester_pays(bool, optional): A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to true, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.   RequesterPays is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.  Valid Values: true | false . Defaults to None.
        smbacl_enabled(bool, optional): Set this value to true to enable access control list (ACL) on the SMB file share. Set it to false to map file and directory permissions to the POSIX permissions. For more information, see Using Microsoft Windows ACLs to control access to an SMB file share in the Storage Gateway User Guide. Valid Values: true | false . Defaults to None.
        access_based_enumeration(bool, optional): The files and folders on this share will only be visible to users with read access. Defaults to None.
        admin_user_list(List, optional): A list of users or groups in the Active Directory that have administrator rights to the file share. A group must be prefixed with the @ character. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only be set if Authentication is set to ActiveDirectory. Defaults to None.
        valid_user_list(List, optional): A list of users or groups in the Active Directory that are allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only be set if Authentication is set to ActiveDirectory. Defaults to None.
        invalid_user_list(List, optional): A list of users or groups in the Active Directory that are not allowed to access the file share. A group must be prefixed with the @ character. Acceptable formats include: DOMAIN\User1, user1, @group1, and @DOMAIN\group1. Can only be set if Authentication is set to ActiveDirectory. Defaults to None.
        audit_destination_arn(str, optional): The Amazon Resource Name (ARN) of the storage used for audit logs. Defaults to None.
        case_sensitivity(str, optional): The case of an object name in an Amazon S3 bucket. For ClientSpecified, the client determines the case sensitivity. For CaseSensitive, the gateway determines the case sensitivity. The default value is ClientSpecified. Defaults to None.
        file_share_name(str, optional): The name of the file share. Optional.   FileShareName must be set if an S3 prefix name is set in LocationARN. . Defaults to None.
        cache_attributes(Dict, optional): Specifies refresh cache information for the file share. Defaults to None.
        notification_policy(str, optional): The notification policy of the file share. SettlingTimeInSeconds controls the number of seconds to wait after the last point in time a client wrote to a file before generating an ObjectUploaded notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.   SettlingTimeInSeconds has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.  The following example sets NotificationPolicy on with SettlingTimeInSeconds set to 60.  {\"Upload\": {\"SettlingTimeInSeconds\": 60}}  The following example sets NotificationPolicy off.  {} . Defaults to None.
        oplocks_enabled(bool, optional): Specifies whether opportunistic locking is enabled for the SMB file share.  Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve access to files with the same name in different case.  Valid Values: true | false . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.smb.file_share.init.update(
                ctx, file_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.smb.file_share.init.update file_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_smb_file_share",
        op_kwargs={
            "FileShareARN": file_share_arn,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "DefaultStorageClass": default_storage_class,
            "ObjectACL": object_acl,
            "ReadOnly": read_only,
            "GuessMIMETypeEnabled": guess_mime_type_enabled,
            "RequesterPays": requester_pays,
            "SMBACLEnabled": smbacl_enabled,
            "AccessBasedEnumeration": access_based_enumeration,
            "AdminUserList": admin_user_list,
            "ValidUserList": valid_user_list,
            "InvalidUserList": invalid_user_list,
            "AuditDestinationARN": audit_destination_arn,
            "CaseSensitivity": case_sensitivity,
            "FileShareName": file_share_name,
            "CacheAttributes": cache_attributes,
            "NotificationPolicy": notification_policy,
            "OplocksEnabled": oplocks_enabled,
        },
    )
