"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns your gateway's weekly maintenance start time including the day and time of the week. Note that values are in terms of the gateway's time zone.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.maintenance_start_time.describe(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.maintenance_start_time.describe gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_maintenance_start_time",
        op_kwargs={"GatewayARN": gateway_arn},
    )


async def update(
    hub,
    ctx,
    gateway_arn: str,
    hour_of_day: int,
    minute_of_hour: int,
    day_of_week: int = None,
    day_of_month: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        hour_of_day(int): The hour component of the maintenance start time represented as hh, where hh is the hour (00 to 23). The hour of the day is in the time zone of the gateway.
        minute_of_hour(int): The minute component of the maintenance start time represented as mm, where mm is the minute (00 to 59). The minute of the hour is in the time zone of the gateway.
        day_of_week(int, optional): The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6, where 0 represents Sunday and 6 Saturday. Defaults to None.
        day_of_month(int, optional): The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where 1 represents the first day of the month and 28 represents the last day of the month. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.maintenance_start_time.update(
                ctx, gateway_arn=value, hour_of_day=value, minute_of_hour=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.maintenance_start_time.update gateway_arn=value, hour_of_day=value, minute_of_hour=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_maintenance_start_time",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "HourOfDay": hour_of_day,
            "MinuteOfHour": minute_of_hour,
            "DayOfWeek": day_of_week,
            "DayOfMonth": day_of_month,
        },
    )
