"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, gateway_arn: str, local_console_password: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don't need to know the default password to set a new password.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        local_console_password(str): The password you want to set for your VM local console.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.local.console_password.set(
                ctx, gateway_arn=value, local_console_password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.local.console_password.set gateway_arn=value, local_console_password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="set_local_console_password",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "LocalConsolePassword": local_console_password,
        },
    )
