"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not). To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.gateway.information.describe_all(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.gateway.information.describe_all gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_gateway_information",
        op_kwargs={"GatewayARN": gateway_arn},
    )


async def update_multiple(
    hub,
    ctx,
    gateway_arn: str,
    gateway_name: str = None,
    gateway_timezone: str = None,
    cloud_watch_log_group_arn: str = None,
    gateway_capacity: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a gateway's metadata, which includes the gateway's name and time zone. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.  For gateways activated after September 2, 2015, the gateway's ARN contains the gateway ID rather than the gateway name. However, changing the name of the gateway has no effect on the gateway's ARN.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        gateway_name(str, optional): The name you configured for your gateway. Defaults to None.
        gateway_timezone(str, optional): A value that indicates the time zone of the gateway. Defaults to None.
        cloud_watch_log_group_arn(str, optional): The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use to monitor and log events in the gateway. For more information, see What is Amazon CloudWatch Logs? . Defaults to None.
        gateway_capacity(str, optional): Specifies the size of the gateway's metadata cache. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.gateway.information.update_multiple(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.gateway.information.update_multiple gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_gateway_information",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "GatewayName": gateway_name,
            "GatewayTimezone": gateway_timezone,
            "CloudWatchLogGroupARN": cloud_watch_log_group_arn,
            "GatewayCapacity": gateway_capacity,
        },
    )
