"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    user_name: str,
    password: str,
    client_token: str,
    gateway_arn: str,
    location_arn: str,
    tags: List = None,
    audit_destination_arn: str = None,
    cache_attributes: Dict = None,
    endpoint_network_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.

    Args:
        user_name(str): The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group.
        password(str): The password of the user credential.
        client_token(str): A unique string value that you supply that is used by the FSx File Gateway to ensure idempotent file system association creation.
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        location_arn(str): The Amazon Resource Name (ARN) of the Amazon FSx file system to associate with the FSx File Gateway.
        tags(List, optional): A list of up to 50 tags that can be assigned to the file system association. Each tag is a key-value pair. Defaults to None.
        audit_destination_arn(str, optional): The Amazon Resource Name (ARN) of the storage used for the audit logs. Defaults to None.
        cache_attributes(Dict, optional): The refresh cache information for the file share or FSx file systems. Defaults to None.
        endpoint_network_configuration(Dict, optional): Specifies the network configuration information for the gateway associated with the Amazon FSx file system.  If multiple file systems are associated with this gateway, this parameter's IpAddresses field is required. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.file.system.init.associate(
                ctx,
                user_name=value,
                password=value,
                client_token=value,
                gateway_arn=value,
                location_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.file.system.init.associate user_name=value, password=value, client_token=value, gateway_arn=value, location_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="associate_file_system",
        op_kwargs={
            "UserName": user_name,
            "Password": password,
            "ClientToken": client_token,
            "GatewayARN": gateway_arn,
            "LocationARN": location_arn,
            "Tags": tags,
            "AuditDestinationARN": audit_destination_arn,
            "CacheAttributes": cache_attributes,
            "EndpointNetworkConfiguration": endpoint_network_configuration,
        },
    )


async def disassociate(
    hub, ctx, file_system_association_arn: str, force_delete: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.

    Args:
        file_system_association_arn(str): The Amazon Resource Name (ARN) of the file system association to be deleted.
        force_delete(bool, optional): If this value is set to true, the operation disassociates an Amazon FSx file system immediately. It ends all data uploads to the file system, and the file system association enters the FORCE_DELETING status. If this value is set to false, the Amazon FSx file system does not disassociate until all data is uploaded. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.file.system.init.disassociate(
                ctx, file_system_association_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.file.system.init.disassociate file_system_association_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="disassociate_file_system",
        op_kwargs={
            "FileSystemAssociationARN": file_system_association_arn,
            "ForceDelete": force_delete,
        },
    )
