"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, file_system_association_arn_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets the file system association information. This operation is only supported for FSx File Gateways.

    Args:
        file_system_association_arn_list(List): An array containing the Amazon Resource Name (ARN) of each file system association to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.file.system.association.describe_all(
                ctx, file_system_association_arn_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.file.system.association.describe_all file_system_association_arn_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_file_system_associations",
        op_kwargs={"FileSystemAssociationARNList": file_system_association_arn_list},
    )


async def list_all(
    hub, ctx, gateway_arn: str = None, limit: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of FileSystemAssociationSummary objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.

    Args:
        gateway_arn(str, optional): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region. Defaults to None.
        limit(int, optional): The maximum number of file system associations to return in the response. If present, Limit must be an integer with a value greater than zero. Optional. Defaults to None.
        marker(str, optional): Opaque pagination token returned from a previous ListFileSystemAssociations operation. If present, Marker specifies where to continue the list from after a previous call to ListFileSystemAssociations. Optional. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.file.system.association.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.file.system.association.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_file_system_associations",
        op_kwargs={"GatewayARN": gateway_arn, "Limit": limit, "Marker": marker},
    )


async def update(
    hub,
    ctx,
    file_system_association_arn: str,
    user_name: str = None,
    password: str = None,
    audit_destination_arn: str = None,
    cache_attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a file system association. This operation is only supported in the FSx File Gateways.

    Args:
        file_system_association_arn(str): The Amazon Resource Name (ARN) of the file system association that you want to update.
        user_name(str, optional): The user name of the user credential that has permission to access the root share D$ of the Amazon FSx file system. The user account must belong to the Amazon FSx delegated admin user group. Defaults to None.
        password(str, optional): The password of the user credential. Defaults to None.
        audit_destination_arn(str, optional): The Amazon Resource Name (ARN) of the storage used for the audit logs. Defaults to None.
        cache_attributes(Dict, optional): The refresh cache information for the file share or FSx file systems. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.file.system.association.update(
                ctx, file_system_association_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.file.system.association.update file_system_association_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_file_system_association",
        op_kwargs={
            "FileSystemAssociationARN": file_system_association_arn,
            "UserName": user_name,
            "Password": password,
            "AuditDestinationARN": audit_destination_arn,
            "CacheAttributes": cache_attributes,
        },
    )
