"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def join(
    hub,
    ctx,
    gateway_arn: str,
    domain_name: str,
    user_name: str,
    password: str,
    organizational_unit: str = None,
    domain_controllers: List = None,
    timeout_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        domain_name(str): The name of the domain that you want the gateway to join.
        organizational_unit(str, optional): The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain. Defaults to None.
        domain_controllers(List, optional): List of IPv4 addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number include it after the colon (“:”). For example, mydc.mydomain.com:389. Defaults to None.
        timeout_in_seconds(int, optional): Specifies the time in seconds, in which the JoinDomain operation must complete. The default is 20 seconds. Defaults to None.
        user_name(str): Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user account should be enabled to join computers to the domain. For example, you can use the domain administrator account or an account with delegated permissions to join computers to the domain.
        password(str): Sets the password of the user who has permission to add the gateway to the Active Directory domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.domain.join(
                ctx, gateway_arn=value, domain_name=value, user_name=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.domain.join gateway_arn=value, domain_name=value, user_name=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="join_domain",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "DomainName": domain_name,
            "OrganizationalUnit": organizational_unit,
            "DomainControllers": domain_controllers,
            "TimeoutInSeconds": timeout_in_seconds,
            "UserName": user_name,
            "Password": password,
        },
    )
