"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, target_arn: str, initiator_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.

    Args:
        target_arn(str): The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN for specified VolumeARN.
        initiator_name(str): The iSCSI initiator that connects to the target.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.chap_credential.delete_multiple(
                ctx, target_arn=value, initiator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.chap_credential.delete_multiple target_arn=value, initiator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_chap_credentials",
        op_kwargs={"TargetARN": target_arn, "InitiatorName": initiator_name},
    )


async def describe_all(hub, ctx, target_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.

    Args:
        target_arn(str): The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN for specified VolumeARN.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.chap_credential.describe_all(
                ctx, target_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.chap_credential.describe_all target_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_chap_credentials",
        op_kwargs={"TargetARN": target_arn},
    )


async def update_multiple(
    hub,
    ctx,
    target_arn: str,
    secret_to_authenticate_initiator: str,
    initiator_name: str,
    secret_to_authenticate_target: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.  When you update CHAP credentials, all existing connections on the target are closed and initiators must reconnect with the new credentials.

    Args:
        target_arn(str): The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes operation to return the TargetARN for specified VolumeARN.
        secret_to_authenticate_initiator(str): The secret key that the initiator (for example, the Windows client) must provide to participate in mutual CHAP with the target.  The secret key must be between 12 and 16 bytes when encoded in UTF-8. .
        initiator_name(str): The iSCSI initiator that connects to the target.
        secret_to_authenticate_target(str, optional): The secret key that the target must provide to participate in mutual CHAP with the initiator (e.g. Windows client). Byte constraints: Minimum bytes of 12. Maximum bytes of 16.  The secret key must be between 12 and 16 bytes when encoded in UTF-8. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.chap_credential.update_multiple(
                ctx, target_arn=value, secret_to_authenticate_initiator=value, initiator_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.chap_credential.update_multiple target_arn=value, secret_to_authenticate_initiator=value, initiator_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_chap_credentials",
        op_kwargs={
            "TargetARN": target_arn,
            "SecretToAuthenticateInitiator": secret_to_authenticate_initiator,
            "InitiatorName": initiator_name,
            "SecretToAuthenticateTarget": secret_to_authenticate_target,
        },
    )
