"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    gateway_arn: str,
    volume_size_in_bytes: int,
    target_name: str,
    network_interface_id: str,
    client_token: str,
    snapshot_id: str = None,
    source_volume_arn: str = None,
    kms_encrypted: bool = None,
    kms_key: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.  Cache storage must be allocated to the gateway before you can create a cached volume. Use the AddCache operation to add cache storage to a gateway.  In the request, you must specify the gateway, size of the volume in bytes, the iSCSI target name, an IP address on which to expose the target, and a unique client token. In response, the gateway creates the volume and returns information about it. This information includes the volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN that initiators can use to connect to the volume target. Optionally, you can provide the ARN for an existing volume as the SourceVolumeARN for this cached volume, which creates an exact copy of the existing volume’s latest recovery point. The VolumeSizeInBytes value must be equal to or larger than the size of the copied volume, in bytes.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.
        volume_size_in_bytes(int): The size of the volume in bytes.
        snapshot_id(str, optional): The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if you want to create the iSCSI storage volume from a snapshot; otherwise, do not include this field. To list snapshots for your account use DescribeSnapshots in the Amazon Elastic Compute Cloud API Reference. Defaults to None.
        target_name(str): The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN. For example, specifying TargetName as myvolume results in the target ARN of arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume. The target name must be unique across all volumes on a gateway. If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new target name.
        source_volume_arn(str, optional): The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The VolumeSizeInBytes value for this new volume must be equal to or larger than the size of the existing volume, in bytes. Defaults to None.
        network_interface_id(str): The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a list of the network interfaces available on a gateway. Valid Values: A valid IP address.
        client_token(str): A unique identifier that you use to retry a request. If you retry a request, use the same ClientToken you specified in the initial request.
        kms_encrypted(bool, optional): Set to true to use Amazon S3 server-side encryption with your own KMS key, or false to use a key managed by Amazon S3. Optional. Valid Values: true | false . Defaults to None.
        kms_key(str, optional): The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when KMSEncrypted is true. Optional. Defaults to None.
        tags(List, optional): A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.  Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256 characters. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.cached_iscsi_volume.create(
                ctx,
                gateway_arn=value,
                volume_size_in_bytes=value,
                target_name=value,
                network_interface_id=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.cached_iscsi_volume.create gateway_arn=value, volume_size_in_bytes=value, target_name=value, network_interface_id=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="create_cached_iscsi_volume",
        op_kwargs={
            "GatewayARN": gateway_arn,
            "VolumeSizeInBytes": volume_size_in_bytes,
            "SnapshotId": snapshot_id,
            "TargetName": target_name,
            "SourceVolumeARN": source_volume_arn,
            "NetworkInterfaceId": network_interface_id,
            "ClientToken": client_token,
            "KMSEncrypted": kms_encrypted,
            "KMSKey": kms_key,
            "Tags": tags,
        },
    )


async def describe_all(hub, ctx, volume_ar_ns: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume Amazon Resource Name (ARN).

    Args:
        volume_ar_ns(List): An array of strings where each string represents the Amazon Resource Name (ARN) of a cached volume. All of the specified cached volumes must be from the same gateway. Use ListVolumes to get volume ARNs for a gateway.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.cached_iscsi_volume.describe_all(
                ctx, volume_ar_ns=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.cached_iscsi_volume.describe_all volume_ar_ns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="describe_cached_iscsi_volumes",
        op_kwargs={"VolumeARNs": volume_ar_ns},
    )
