"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.

    Args:
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.automatic_tape_creation_policy.delete(
                ctx, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.automatic_tape_creation_policy.delete gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="delete_automatic_tape_creation_policy",
        op_kwargs={"GatewayARN": gateway_arn},
    )


async def list_all(hub, ctx, gateway_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list. This operation is only supported for tape gateways.

    Args:
        gateway_arn(str, optional): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.automatic_tape_creation_policy.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.automatic_tape_creation_policy.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="list_automatic_tape_creation_policies",
        op_kwargs={"GatewayARN": gateway_arn},
    )


async def update(
    hub, ctx, automatic_tape_creation_rules: List, gateway_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways. By default, there is no automatic tape creation policy.  A gateway can have only one automatic tape creation policy.

    Args:
        automatic_tape_creation_rules(List): An automatic tape creation policy consists of a list of automatic tape creation rules. The rules determine when and how to automatically create new tapes.
        gateway_arn(str): The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.storagegateway.automatic_tape_creation_policy.update(
                ctx, automatic_tape_creation_rules=value, gateway_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.storagegateway.automatic_tape_creation_policy.update automatic_tape_creation_rules=value, gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="storagegateway",
        operation="update_automatic_tape_creation_policy",
        op_kwargs={
            "AutomaticTapeCreationRules": automatic_tape_creation_rules,
            "GatewayARN": gateway_arn,
        },
    )
