"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, task_token: str, output: str) -> Dict:
    r"""
    **Autogenerated function**

    Used by activity workers and task states using the callback pattern to report that the task identified by the taskToken completed successfully.

    Args:
        task_token(str): The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the context object when a workflow enters a task state. See GetActivityTaskOutput$taskToken.
        output(str): The JSON output of the task. Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.task.success.send(
                ctx, task_token=value, output=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.task.success.send task_token=value, output=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="send_task_success",
        op_kwargs={"taskToken": task_token, "output": output},
    )
