"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(hub, ctx, task_token: str, error: str = None, cause: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Used by activity workers and task states using the callback pattern to report that the task identified by the taskToken failed.

    Args:
        task_token(str): The token that represents this task. Task tokens are generated by Step Functions when tasks are assigned to a worker, or in the context object when a workflow enters a task state. See GetActivityTaskOutput$taskToken.
        error(str, optional): The error code of the failure. Defaults to None.
        cause(str, optional): A more detailed explanation of the cause of the failure. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.task.failure.send(ctx, task_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.task.failure.send task_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="send_task_failure",
        op_kwargs={"taskToken": task_token, "error": error, "cause": cause},
    )
