"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    state_machine_arn: str,
    name: str = None,
    input_: str = None,
    trace_header: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a Synchronous Express state machine execution.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine to execute.
        name(str, optional): The name of the execution. Defaults to None.
        input_(str, optional): The string that contains the JSON input data for the execution, for example:  "input": "{\"first_name\" : \"test\"}"   If you don't include any JSON input data, you still must include the two braces, for example: "input": "{}"   Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding. Defaults to None.
        trace_header(str, optional): Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.sync_execution.start(ctx, state_machine_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.sync_execution.start state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="start_sync_execution",
        op_kwargs={
            "stateMachineArn": state_machine_arn,
            "name": name,
            "input": input_,
            "traceHeader": trace_header,
        },
    )
