"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    definition: str,
    role_arn: str,
    type_: str = None,
    logging_configuration: Dict = None,
    tags: List = None,
    tracing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a state machine. A state machine consists of a collection of states that can do work (Task states), determine to which states to transition next (Choice states), stop an execution with an error (Fail states), and so on. State machines are specified using a JSON-based, structured language. For more information, see Amazon States Language in the AWS Step Functions User Guide.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.    CreateStateMachine is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. CreateStateMachine's idempotency check is based on the state machine name, definition, type, LoggingConfiguration and TracingConfiguration. If a following request has a different roleArn or tags, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, roleArn and tags will not be updated, even if they are different.

    Args:
        name(str): The name of the state machine.  A name must not contain:   white space   brackets < > { } [ ]    wildcard characters ? *    special characters " # % \ ^ | ~ ` $ & , ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        definition(str): The Amazon States Language definition of the state machine. See Amazon States Language.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
        type_(str, optional): Determines whether a Standard or Express state machine is created. The default is STANDARD. You cannot update the type of a state machine once it has been created. Defaults to None.
        logging_configuration(Dict, optional): Defines what execution history events are logged and where they are logged.  By default, the level is set to OFF. For more information see Log Levels in the AWS Step Functions User Guide. . Defaults to None.
        tags(List, optional): Tags to be added when creating a state machine. An array of key-value pairs. For more information, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide, and Controlling Access Using IAM Tags. Tags may only contain Unicode letters, digits, white space, or these symbols: _ . : / = + - @. Defaults to None.
        tracing_configuration(Dict, optional): Selects whether AWS X-Ray tracing is enabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.init.create(
                ctx, name=value, definition=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.init.create name=value, definition=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="create_state_machine",
        op_kwargs={
            "name": name,
            "definition": definition,
            "roleArn": role_arn,
            "type": type_,
            "loggingConfiguration": logging_configuration,
            "tags": tags,
            "tracingConfiguration": tracing_configuration,
        },
    )


async def delete(hub, ctx, state_machine_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a state machine. This is an asynchronous operation: It sets the state machine's status to DELETING and begins the deletion process.   For EXPRESSstate machines, the deletion will happen eventually (usually less than a minute). Running executions may emit logs after DeleteStateMachine API is called.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.init.delete(
                ctx, state_machine_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.init.delete state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="delete_state_machine",
        op_kwargs={"stateMachineArn": state_machine_arn},
    )


async def describe(hub, ctx, state_machine_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a state machine.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.init.describe(
                ctx, state_machine_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.init.describe state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="describe_state_machine",
        op_kwargs={"stateMachineArn": state_machine_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the existing state machines. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        max_results(int, optional): The maximum number of results that are returned per call. You can use nextToken to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum. Defaults to None.
        next_token(str, optional): If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="list_state_machines",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    state_machine_arn: str,
    definition: str = None,
    role_arn: str = None,
    logging_configuration: Dict = None,
    tracing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing state machine by modifying its definition, roleArn, or loggingConfiguration. Running executions will continue to use the previous definition and roleArn. You must include at least one of definition or roleArn or you will receive a MissingRequiredParameter error.  All StartExecution calls within a few seconds will use the updated definition and roleArn. Executions started immediately after calling UpdateStateMachine may use the previous state machine definition and roleArn.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine.
        definition(str, optional): The Amazon States Language definition of the state machine. See Amazon States Language. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role of the state machine. Defaults to None.
        logging_configuration(Dict, optional): The LoggingConfiguration data type is used to set CloudWatch Logs options. Defaults to None.
        tracing_configuration(Dict, optional): Selects whether AWS X-Ray tracing is enabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.init.update(
                ctx, state_machine_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.init.update state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="update_state_machine",
        op_kwargs={
            "stateMachineArn": state_machine_arn,
            "definition": definition,
            "roleArn": role_arn,
            "loggingConfiguration": logging_configuration,
            "tracingConfiguration": tracing_configuration,
        },
    )
