"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the state machine associated with a specific execution.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.  This API action is not supported by EXPRESS state machines.

    Args:
        execution_arn(str): The Amazon Resource Name (ARN) of the execution you want state machine information for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.state_machine.for_execution.describe(
                ctx, execution_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.state_machine.for_execution.describe execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="describe_state_machine_for_execution",
        op_kwargs={"executionArn": execution_arn},
    )
