"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, execution_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an execution.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.  This API action is not supported by EXPRESS state machines.

    Args:
        execution_arn(str): The Amazon Resource Name (ARN) of the execution to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.execution.init.describe(ctx, execution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.execution.init.describe execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="describe_execution",
        op_kwargs={"executionArn": execution_arn},
    )


async def list_all(
    hub,
    ctx,
    state_machine_arn: str,
    status_filter: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the executions of a state machine that meet the filtering criteria. Results are sorted by time, with the most recent execution first. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.  This API action is not supported by EXPRESS state machines.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine whose executions is listed.
        status_filter(str, optional): If specified, only list the executions whose current execution status matches the given filter. Defaults to None.
        max_results(int, optional): The maximum number of results that are returned per call. You can use nextToken to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum. Defaults to None.
        next_token(str, optional): If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.execution.init.list_all(
                ctx, state_machine_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.execution.init.list_all state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="list_executions",
        op_kwargs={
            "stateMachineArn": state_machine_arn,
            "statusFilter": status_filter,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    state_machine_arn: str,
    name: str = None,
    input_: str = None,
    trace_header: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a state machine execution.   StartExecution is idempotent. If StartExecution is called with the same name and input as a running execution, the call will succeed and return the same response as the original request. If the execution is closed or if the input is different, it will return a 400 ExecutionAlreadyExists error. Names can be reused after 90 days.

    Args:
        state_machine_arn(str): The Amazon Resource Name (ARN) of the state machine to execute.
        name(str, optional): The name of the execution. This name must be unique for your AWS account, region, and state machine for 90 days. For more information, see  Limits Related to State Machine Executions in the AWS Step Functions Developer Guide. A name must not contain:   white space   brackets < > { } [ ]    wildcard characters ? *    special characters " # % \ ^ | ~ ` $ & , ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _. Defaults to None.
        input_(str, optional): The string that contains the JSON input data for the execution, for example:  "input": "{\"first_name\" : \"test\"}"   If you don't include any JSON input data, you still must include the two braces, for example: "input": "{}"   Length constraints apply to the payload size, and are expressed as bytes in UTF-8 encoding. Defaults to None.
        trace_header(str, optional): Passes the AWS X-Ray trace header. The trace header can also be passed in the request payload. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.execution.init.start(ctx, state_machine_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.execution.init.start state_machine_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="start_execution",
        op_kwargs={
            "stateMachineArn": state_machine_arn,
            "name": name,
            "input": input_,
            "traceHeader": trace_header,
        },
    )


async def stop(
    hub, ctx, execution_arn: str, error: str = None, cause: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Stops an execution. This API action is not supported by EXPRESS state machines.

    Args:
        execution_arn(str): The Amazon Resource Name (ARN) of the execution to stop.
        error(str, optional): The error code of the failure. Defaults to None.
        cause(str, optional): A more detailed explanation of the cause of the failure. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.execution.init.stop(ctx, execution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.execution.init.stop execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="stop_execution",
        op_kwargs={"executionArn": execution_arn, "error": error, "cause": cause},
    )
