"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    execution_arn: str,
    max_results: int = None,
    reverse_order: bool = None,
    next_token: str = None,
    include_execution_data: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the history of the specified execution as a list of events. By default, the results are returned in ascending order of the timeStamp of the events. Use the reverseOrder parameter to get the latest events first. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error. This API action is not supported by EXPRESS state machines.

    Args:
        execution_arn(str): The Amazon Resource Name (ARN) of the execution.
        max_results(int, optional): The maximum number of results that are returned per call. You can use nextToken to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum. Defaults to None.
        reverse_order(bool, optional): Lists events in descending order of their timeStamp. Defaults to None.
        next_token(str, optional): If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error. Defaults to None.
        include_execution_data(bool, optional): You can select whether execution data (input or output of a history event) is returned. The default is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.execution.history.get(ctx, execution_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.execution.history.get execution_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="get_execution_history",
        op_kwargs={
            "executionArn": execution_arn,
            "maxResults": max_results,
            "reverseOrder": reverse_order,
            "nextToken": next_token,
            "includeExecutionData": include_execution_data,
        },
    )
