"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, activity_arn: str, worker_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a taskToken with a null string.  Workers should set their client side socket timeout to at least 65 seconds (5 seconds higher than the maximum time the service may hold the poll request). Polling with GetActivityTask can cause latency in some implementations. See Avoid Latency When Polling for Activity Tasks in the Step Functions Developer Guide.

    Args:
        activity_arn(str): The Amazon Resource Name (ARN) of the activity to retrieve tasks from (assigned when you create the task using CreateActivity.).
        worker_name(str, optional): You can provide an arbitrary name in order to identify the worker that the task is assigned to. This name is used when it is logged in the execution history. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.activity.task.get(ctx, activity_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.activity.task.get activity_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="get_activity_task",
        op_kwargs={"activityArn": activity_arn, "workerName": worker_name},
    )
