"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, name: str, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an activity. An activity is a task that you write in any programming language and host on any machine that has access to AWS Step Functions. Activities must poll Step Functions using the GetActivityTask API action and respond using SendTask* API actions. This function lets Step Functions know the existence of your activity and returns an identifier for use in a state machine and when polling from the activity.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.    CreateActivity is an idempotent API. Subsequent requests won’t create a duplicate resource if it was already created. CreateActivity's idempotency check is based on the activity name. If a following request has different tags values, Step Functions will ignore these differences and treat it as an idempotent request of the previous. In this case, tags will not be updated, even if they are different.

    Args:
        name(str): The name of the activity to create. This name must be unique for your AWS account and region for 90 days. For more information, see  Limits Related to State Machine Executions in the AWS Step Functions Developer Guide. A name must not contain:   white space   brackets < > { } [ ]    wildcard characters ? *    special characters " # % \ ^ | ~ ` $ & , ; : /    control characters (U+0000-001F, U+007F-009F)   To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        tags(List, optional): The list of tags to add to a resource. An array of key-value pairs. For more information, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide, and Controlling Access Using IAM Tags. Tags may only contain Unicode letters, digits, white space, or these symbols: _ . : / = + - @. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.activity.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.activity.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="create_activity",
        op_kwargs={"name": name, "tags": tags},
    )


async def delete(hub, ctx, activity_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an activity.

    Args:
        activity_arn(str): The Amazon Resource Name (ARN) of the activity to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.activity.init.delete(ctx, activity_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.activity.init.delete activity_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="delete_activity",
        op_kwargs={"activityArn": activity_arn},
    )


async def describe(hub, ctx, activity_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an activity.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        activity_arn(str): The Amazon Resource Name (ARN) of the activity to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.activity.init.describe(ctx, activity_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.activity.init.describe activity_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="describe_activity",
        op_kwargs={"activityArn": activity_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the existing activities. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.  This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.

    Args:
        max_results(int, optional): The maximum number of results that are returned per call. You can use nextToken to obtain further pages of results. The default is 100 and the maximum allowed page size is 1000. A value of 0 uses the default. This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum. Defaults to None.
        next_token(str, optional): If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.stepfunction.activity.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.stepfunction.activity.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="stepfunctions",
        operation="list_activities",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
