"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_id: str,
    client_secret: str,
    grant_type: str,
    device_code: str,
    code: str = None,
    refresh_token: str = None,
    scope: List = None,
    redirect_uri: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and returns an access token for the authorized client. The access token issued will be used to fetch short-term credentials for the assigned roles in the AWS account.

    Args:
        client_id(str): The unique identifier string for each client. This value should come from the persisted result of the RegisterClient API.
        client_secret(str): A secret string generated for the client. This value should come from the persisted result of the RegisterClient API.
        grant_type(str): Supports grant types for authorization code, refresh token, and device code request.
        device_code(str): Used only when calling this API for the device code grant type. This short-term code is used to identify this authentication attempt. This should come from an in-memory reference to the result of the StartDeviceAuthorization API.
        code(str, optional): The authorization code received from the authorization service. This parameter is required to perform an authorization grant request to get access to a token. Defaults to None.
        refresh_token(str, optional): The token used to obtain an access token in the event that the access token is invalid or expired. This token is not issued by the service. Defaults to None.
        scope(List, optional): The list of scopes that is defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token. Defaults to None.
        redirect_uri(str, optional): The location of the application that will receive the authorization code. Users authorize the service to send the request to this location. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_oidc.token.create(
                ctx, client_id=value, client_secret=value, grant_type=value, device_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_oidc.token.create client_id=value, client_secret=value, grant_type=value, device_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-oidc",
        operation="create_token",
        op_kwargs={
            "clientId": client_id,
            "clientSecret": client_secret,
            "grantType": grant_type,
            "deviceCode": device_code,
            "code": code,
            "refreshToken": refresh_token,
            "scope": scope,
            "redirectUri": redirect_uri,
        },
    )
