"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, client_id: str, client_secret: str, start_url: str) -> Dict:
    r"""
    **Autogenerated function**

    Initiates device authorization by requesting a pair of verification codes from the authorization service.

    Args:
        client_id(str): The unique identifier string for the client that is registered with AWS SSO. This value should come from the persisted result of the RegisterClient API operation.
        client_secret(str): A secret string that is generated for the client. This value should come from the persisted result of the RegisterClient API operation.
        start_url(str): The URL for the AWS SSO user portal. For more information, see Using the User Portal in the AWS Single Sign-On User Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_oidc.device_authorization.start(
                ctx, client_id=value, client_secret=value, start_url=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_oidc.device_authorization.start client_id=value, client_secret=value, start_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-oidc",
        operation="start_device_authorization",
        op_kwargs={
            "clientId": client_id,
            "clientSecret": client_secret,
            "startUrl": start_url,
        },
    )
