"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def register(
    hub, ctx, client_name: str, client_type: str, scopes: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a client with AWS SSO. This allows clients to initiate device authorization. The output should be persisted for reuse through many authentication requests.

    Args:
        client_name(str): The friendly name of the client.
        client_type(str): The type of client. The service supports only public as a client type. Anything other than public will be rejected by the service.
        scopes(List, optional): The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_oidc.client.register(
                ctx, client_name=value, client_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_oidc.client.register client_name=value, client_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-oidc",
        operation="register_client",
        op_kwargs={
            "clientName": client_name,
            "clientType": client_type,
            "scopes": scopes,
        },
    )
