"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, instance_arn: str, resource_arn: str, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags that are attached to a specified resource.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        resource_arn(str): The ARN of the resource with the tags to be listed.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.tags_for_resource.list(
                ctx, instance_arn=value, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.tags_for_resource.list instance_arn=value, resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_tags_for_resource",
        op_kwargs={
            "InstanceArn": instance_arn,
            "ResourceArn": resource_arn,
            "NextToken": next_token,
        },
    )
