"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, instance_arn: str, resource_arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates a set of tags with a specified resource.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        resource_arn(str): The ARN of the resource with the tags to be listed.
        tags(List): A set of key-value pairs that are used to manage the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.resource.tag(
                ctx, instance_arn=value, resource_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.resource.tag instance_arn=value, resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="tag_resource",
        op_kwargs={
            "InstanceArn": instance_arn,
            "ResourceArn": resource_arn,
            "Tags": tags,
        },
    )


async def untag(hub, ctx, instance_arn: str, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a set of tags from a specified resource.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        resource_arn(str): The ARN of the resource with the tags to be listed.
        tag_keys(List): The keys of tags that are attached to the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.resource.untag(
                ctx, instance_arn=value, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.resource.untag instance_arn=value, resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="untag_resource",
        op_kwargs={
            "InstanceArn": instance_arn,
            "ResourceArn": resource_arn,
            "TagKeys": tag_keys,
        },
    )
