"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    instance_arn: str,
    account_id: str,
    provisioning_status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the permission sets that are provisioned to a specified Amazon Web Services account.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        account_id(str): The identifier of the Amazon Web Services account from which to list the assignments.
        provisioning_status(str, optional): The status object for the permission set provisioning operation. Defaults to None.
        max_results(int, optional): The maximum number of results to display for the assignment. Defaults to None.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.sets_provisioned_to_account.list(
                ctx, instance_arn=value, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.sets_provisioned_to_account.list instance_arn=value, account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_permission_sets_provisioned_to_account",
        op_kwargs={
            "InstanceArn": instance_arn,
            "AccountId": account_id,
            "ProvisioningStatus": provisioning_status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
