"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def describe(
    hub, ctx, instance_arn: str, provision_permission_set_request_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the status for the given permission set provisioning request.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        provision_permission_set_request_id(str): The identifier that is provided by the ProvisionPermissionSet call to retrieve the current status of the provisioning workflow.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.provisioning_status.describe(
                ctx, instance_arn=value, provision_permission_set_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.provisioning_status.describe instance_arn=value, provision_permission_set_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="describe_permission_set_provisioning_status",
        op_kwargs={
            "InstanceArn": instance_arn,
            "ProvisionPermissionSetRequestId": provision_permission_set_request_id,
        },
    )


async def list_(
    hub,
    ctx,
    instance_arn: str,
    max_results: int = None,
    next_token: str = None,
    filter_: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the status of the permission set provisioning requests for a specified SSO instance.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        max_results(int, optional): The maximum number of results to display for the assignment. Defaults to None.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.
        filter_(Dict, optional): Filters results based on the passed attribute value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.provisioning_status.list(
                ctx, instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.provisioning_status.list instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_permission_set_provisioning_status",
        op_kwargs={
            "InstanceArn": instance_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filter": filter_,
        },
    )
