"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    instance_arn: str,
    description: str = None,
    session_duration: str = None,
    relay_state: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a permission set within a specified SSO instance.  To grant users and groups access to Amazon Web Services account resources, use  CreateAccountAssignment .

    Args:
        name(str): The name of the PermissionSet.
        description(str, optional): The description of the PermissionSet. Defaults to None.
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        session_duration(str, optional): The length of time that the application user sessions are valid in the ISO-8601 standard. Defaults to None.
        relay_state(str, optional): Used to redirect users within the application during the federation authentication process. Defaults to None.
        tags(List, optional): The tags to attach to the new PermissionSet. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.create(
                ctx, name=value, instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.create name=value, instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="create_permission_set",
        op_kwargs={
            "Name": name,
            "Description": description,
            "InstanceArn": instance_arn,
            "SessionDuration": session_duration,
            "RelayState": relay_state,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, instance_arn: str, permission_set_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set that should be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.delete(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.delete instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="delete_permission_set",
        op_kwargs={"InstanceArn": instance_arn, "PermissionSetArn": permission_set_arn},
    )


async def describe(hub, ctx, instance_arn: str, permission_set_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details of the permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.describe(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.describe instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="describe_permission_set",
        op_kwargs={"InstanceArn": instance_arn, "PermissionSetArn": permission_set_arn},
    )


async def list_all(
    hub, ctx, instance_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the PermissionSets in an SSO instance.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.
        max_results(int, optional): The maximum number of results to display for the assignment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.list_all(ctx, instance_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.list_all instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_permission_sets",
        op_kwargs={
            "InstanceArn": instance_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def provision(
    hub,
    ctx,
    instance_arn: str,
    permission_set_arn: str,
    target_type: str,
    target_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The process by which a specified permission set is provisioned to the specified target.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set.
        target_id(str, optional): TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012). Defaults to None.
        target_type(str): The entity type for which the assignment will be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.provision(
                ctx, instance_arn=value, permission_set_arn=value, target_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.provision instance_arn=value, permission_set_arn=value, target_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="provision_permission_set",
        op_kwargs={
            "InstanceArn": instance_arn,
            "PermissionSetArn": permission_set_arn,
            "TargetId": target_id,
            "TargetType": target_type,
        },
    )


async def update(
    hub,
    ctx,
    instance_arn: str,
    permission_set_arn: str,
    description: str = None,
    session_duration: str = None,
    relay_state: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set.
        description(str, optional): The description of the PermissionSet. Defaults to None.
        session_duration(str, optional): The length of time that the application user sessions are valid for in the ISO-8601 standard. Defaults to None.
        relay_state(str, optional): Used to redirect users within the application during the federation authentication process. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.permission.set_.init.update(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.permission.set_.init.update instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="update_permission_set",
        op_kwargs={
            "InstanceArn": instance_arn,
            "PermissionSetArn": permission_set_arn,
            "Description": description,
            "SessionDuration": session_duration,
            "RelayState": relay_state,
        },
    )
