"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "in_permission_set"


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    instance_arn: str,
    permission_set_arn: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the IAM managed policy that is attached to a specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the PermissionSet whose managed policies will be listed.
        max_results(int, optional): The maximum number of results to display for the PermissionSet. Defaults to None.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.managed_policy.in_permission_set_.list(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.managed_policy.in_permission_set.list instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_managed_policies_in_permission_set",
        op_kwargs={
            "InstanceArn": instance_arn,
            "PermissionSetArn": permission_set_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
