"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "from_permission_set"


async def detach(
    hub, ctx, instance_arn: str, permission_set_arn: str, managed_policy_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Detaches the attached IAM managed policy ARN from the specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the PermissionSet from which the policy should be detached.
        managed_policy_arn(str): The IAM managed policy ARN to be attached to a permission set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.managed_policy.from_permission_set_.detach(
                ctx, instance_arn=value, permission_set_arn=value, managed_policy_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.managed_policy.from_permission_set.detach instance_arn=value, permission_set_arn=value, managed_policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="detach_managed_policy_from_permission_set",
        op_kwargs={
            "InstanceArn": instance_arn,
            "PermissionSetArn": permission_set_arn,
            "ManagedPolicyArn": managed_policy_arn,
        },
    )
