"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the SSO instances that the caller has access to.

    Args:
        max_results(int, optional): The maximum number of results to display for the instance. Defaults to None.
        next_token(str, optional): The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="list_instances",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
