"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, instance_arn: str, instance_access_control_attribute_configuration: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see Attribute-Based Access Control in the Amazon Web Services SSO User Guide.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed.
        instance_access_control_attribute_configuration(Dict): Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.instance.access_control_attribute_configuration.create(
                ctx, instance_arn=value, instance_access_control_attribute_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.instance.access_control_attribute_configuration.create instance_arn=value, instance_access_control_attribute_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="create_instance_access_control_attribute_configuration",
        op_kwargs={
            "InstanceArn": instance_arn,
            "InstanceAccessControlAttributeConfiguration": instance_access_control_attribute_configuration,
        },
    )


async def delete(hub, ctx, instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see Attribute-Based Access Control in the Amazon Web Services SSO User Guide.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.instance.access_control_attribute_configuration.delete(
                ctx, instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.instance.access_control_attribute_configuration.delete instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="delete_instance_access_control_attribute_configuration",
        op_kwargs={"InstanceArn": instance_arn},
    )


async def describe(hub, ctx, instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see Attribute-Based Access Control in the Amazon Web Services SSO User Guide.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.instance.access_control_attribute_configuration.describe(
                ctx, instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.instance.access_control_attribute_configuration.describe instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="describe_instance_access_control_attribute_configuration",
        op_kwargs={"InstanceArn": instance_arn},
    )


async def update(
    hub, ctx, instance_arn: str, instance_access_control_attribute_configuration: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see Attribute-Based Access Control in the Amazon Web Services SSO User Guide.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed.
        instance_access_control_attribute_configuration(Dict): Updates the attributes for your ABAC configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.instance.access_control_attribute_configuration.update(
                ctx, instance_arn=value, instance_access_control_attribute_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.instance.access_control_attribute_configuration.update instance_arn=value, instance_access_control_attribute_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="update_instance_access_control_attribute_configuration",
        op_kwargs={
            "InstanceArn": instance_arn,
            "InstanceAccessControlAttributeConfiguration": instance_access_control_attribute_configuration,
        },
    )
