"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "to_permission_set"


async def put(
    hub, ctx, instance_arn: str, permission_set_arn: str, inline_policy: str
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches an IAM inline policy to a permission set.  If the permission set is already referenced by one or more account assignments, you will need to call  ProvisionPermissionSet  after this action to apply the corresponding IAM policy updates to all assigned accounts.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set.
        inline_policy(str): The IAM inline policy to attach to a PermissionSet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.inline_policy.to_permission_set_.put(
                ctx, instance_arn=value, permission_set_arn=value, inline_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.inline_policy.to_permission_set.put instance_arn=value, permission_set_arn=value, inline_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="put_inline_policy_to_permission_set",
        op_kwargs={
            "InstanceArn": instance_arn,
            "PermissionSetArn": permission_set_arn,
            "InlinePolicy": inline_policy,
        },
    )
