"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "from_permission_set"


async def delete(hub, ctx, instance_arn: str, permission_set_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the inline policy from a specified permission set.

    Args:
        instance_arn(str): The ARN of the SSO instance under which the operation will be executed. For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services General Reference.
        permission_set_arn(str): The ARN of the permission set that will be used to remove access.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sso_admin.inline_policy.from_permission_set_.delete(
                ctx, instance_arn=value, permission_set_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sso_admin.inline_policy.from_permission_set.delete instance_arn=value, permission_set_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sso-admin",
        operation="delete_inline_policy_from_permission_set",
        op_kwargs={"InstanceArn": instance_arn, "PermissionSetArn": permission_set_arn},
    )
